/*
 * Decompiled with CFR 0.152.
 */
package ai.devtools.selenium;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

final class NetUtils {
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    NetUtils() {
    }

    private static Response basicPOST(OkHttpClient client, HttpUrl baseURL, String endpoint, RequestBody b) throws IOException {
        return client.newCall(new Request.Builder().url(baseURL.newBuilder().addPathSegment(endpoint).build()).post(b).build()).execute();
    }

    public static JsonObject post(String url, JsonObject json) throws IOException {
        JsonObject jsonObject;
        block8: {
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(Duration.ofSeconds(30L)).readTimeout(Duration.ofSeconds(30L)).build();
            FormBody payload = new FormBody.Builder().add("json", json.toString()).build();
            Request request = new Request.Builder().url(url).post((RequestBody)payload).build();
            Call call = client.newCall(request);
            Response response = client.newCall(request).execute();
            try {
                jsonObject = (JsonObject)new Gson().fromJson(response.body().string(), JsonObject.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            response.close();
        }
        return jsonObject;
    }

    public static Response basicPOST(OkHttpClient client, HttpUrl baseURL, String endpoint, JsonObject jo) throws IOException {
        return NetUtils.basicPOST(client, baseURL, endpoint, RequestBody.create((String)jo.toString(), (MediaType)JSON));
    }

    public static Response basicPOST(OkHttpClient client, HttpUrl baseURL, String endpoint, HashMap<String, String> form) throws IOException {
        FormBody.Builder fb = new FormBody.Builder();
        form.forEach((arg_0, arg_1) -> ((FormBody.Builder)fb).add(arg_0, arg_1));
        return NetUtils.basicPOST(client, baseURL, endpoint, (RequestBody)fb.build());
    }

    static OkHttpClient.Builder basicClient() {
        Duration d = Duration.ofSeconds(60L);
        return new OkHttpClient.Builder().connectTimeout(d).writeTimeout(d).readTimeout(d).callTimeout(d);
    }

    public static OkHttpClient unsafeClient() {
        try {
            TrustManager[] tl = new TrustManager[]{new TrustAllX509Manager()};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, tl, new SecureRandom());
            return NetUtils.basicClient().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)tl[0]).hostnameVerifier((HostnameVerifier)new TrustAllHostnameVerifier()).build();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static class TrustAllX509Manager
    implements X509TrustManager {
        private TrustAllX509Manager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

