/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pingplusplus.exception.ChannelException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public class WxpubOAuth {
    public static final String CHARSET = "UTF-8";

    public static String getOpenId(String appId, String appSecret, String code) throws UnsupportedEncodingException, ChannelException {
        String url = WxpubOAuth.createOauthUrlForOpenid(appId, appSecret, code);
        String ret = WxpubOAuth.httpGet(url);
        OAuthResult oAuthResult = (OAuthResult)new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create().fromJson(ret, OAuthResult.class);
        if (oAuthResult.getErrmsg() != null) {
            throw new ChannelException(oAuthResult.getErrmsg(), null, null, oAuthResult.getErrcode().toString(), 0, null);
        }
        return oAuthResult.getOpenid();
    }

    public static String createOauthUrlForCode(String appId, String redirectUrl, boolean moreInfo) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("https://open.weixin.qq.com/connect/oauth2/authorize?");
        sb.append("appid=").append(appId);
        sb.append("&redirect_uri=").append(URLEncoder.encode(redirectUrl, CHARSET));
        sb.append("&response_type=code");
        sb.append("&scope=").append(moreInfo ? "snsapi_userinfo" : "snsapi_base");
        sb.append("&state=pingpp");
        sb.append("#wechat_redirect");
        return sb.toString();
    }

    private static String createOauthUrlForOpenid(String appId, String appSecret, String code) throws UnsupportedEncodingException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("appid", appId);
        data.put("secret", appSecret);
        data.put("code", code);
        data.put("grant_type", "authorization_code");
        String queryString = WxpubOAuth.httpBuildQuery(data);
        return "https://api.weixin.qq.com/sns/oauth2/access_token?" + queryString;
    }

    protected static String httpBuildQuery(Map<String, String> queryString) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : queryString.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(URLEncoder.encode(e.getKey(), CHARSET)).append('=').append(URLEncoder.encode(e.getValue(), CHARSET));
        }
        return sb.toString();
    }

    protected static String httpGet(String urlString) {
        String result = "";
        try {
            String line;
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result = result + line;
            }
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getJsapiTicket(String appId, String appSecret) throws UnsupportedEncodingException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("appid", appId);
        data.put("secret", appSecret);
        data.put("grant_type", "client_credential");
        String queryString = WxpubOAuth.httpBuildQuery(data);
        String accessTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?" + queryString;
        String resp = WxpubOAuth.httpGet(accessTokenUrl);
        JsonParser jp = new JsonParser();
        JsonObject respJson = jp.parse(resp).getAsJsonObject();
        if (respJson.has("errcode")) {
            return respJson.toString();
        }
        data.clear();
        data.put("access_token", respJson.get("access_token").getAsString());
        data.put("type", "jsapi");
        queryString = WxpubOAuth.httpBuildQuery(data);
        String jsapiTicketUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?" + queryString;
        resp = WxpubOAuth.httpGet(jsapiTicketUrl);
        JsonObject ticket = jp.parse(resp).getAsJsonObject();
        return ticket.get("ticket").getAsString();
    }

    public static String getSignature(String charge, String jsapiTicket, String url) {
        if (null == charge || null == jsapiTicket || charge.isEmpty() || jsapiTicket.isEmpty()) {
            return null;
        }
        JsonParser jp = new JsonParser();
        JsonObject chargeJson = jp.parse(charge).getAsJsonObject();
        if (!chargeJson.has("credential")) {
            return null;
        }
        JsonObject credential = chargeJson.get("credential").getAsJsonObject();
        if (!credential.has("wx_pub")) {
            return null;
        }
        JsonObject wx_pub = credential.get("wx_pub").getAsJsonObject();
        String signature = "";
        String string1 = "jsapi_ticket=" + jsapiTicket + "&noncestr=" + wx_pub.get("nonceStr").getAsString() + "&timestamp=" + wx_pub.get("timeStamp").getAsString() + "&url=" + url;
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes(CHARSET));
            signature = WxpubOAuth.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return signature;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    class OAuthResult {
        String accessToken;
        int expiresIn;
        String refreshToken;
        String openid;
        String scope;
        Integer errcode;
        String errmsg;

        OAuthResult() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public int getExpiresIn() {
            return this.expiresIn;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getOpenid() {
            return this.openid;
        }

        public String getScope() {
            return this.scope;
        }

        public Integer getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }
    }
}

