/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.exception.PingppException;
import com.pingplusplus.exception.RateLimitException;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeRefundCollection;
import com.pingplusplus.model.EventData;
import com.pingplusplus.model.PingppError;
import com.pingplusplus.model.PingppObject;
import com.pingplusplus.model.PingppRawJsonObject;
import com.pingplusplus.model.RedEnvelope;
import com.pingplusplus.model.SubApp;
import com.pingplusplus.model.Transfer;
import com.pingplusplus.net.HttpClient;
import com.pingplusplus.net.HttpURLConnectionClient;
import com.pingplusplus.net.PingppRequest;
import com.pingplusplus.net.PingppResponse;
import com.pingplusplus.net.RequestOptions;
import com.pingplusplus.serializer.ChargeDeserializer;
import com.pingplusplus.serializer.ChargeRefundCollectionDeserializer;
import com.pingplusplus.serializer.EventDataDeserializer;
import com.pingplusplus.serializer.PingppRawJsonObjectDeserializer;
import com.pingplusplus.serializer.RedEnvelopeDeserializer;
import com.pingplusplus.serializer.SubAppDeserializer;
import com.pingplusplus.serializer.TransferDeserializer;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public abstract class APIResource
extends PingppObject {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static HttpClient httpClient = new HttpURLConnectionClient();
    public static final String URIAppIdHolder = "<APP_ID>";
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Charge.class, (Object)new ChargeDeserializer()).registerTypeAdapter(RedEnvelope.class, (Object)new RedEnvelopeDeserializer()).registerTypeAdapter(Transfer.class, (Object)new TransferDeserializer()).registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).registerTypeAdapter(EventData.class, (Object)new EventDataDeserializer()).registerTypeAdapter(PingppRawJsonObject.class, (Object)new PingppRawJsonObjectDeserializer()).registerTypeAdapter(SubApp.class, (Object)new SubAppDeserializer()).create();

    public static Gson getGson() {
        return GSON;
    }

    public static Class<?> getSelfClass() {
        return APIResource.class;
    }

    protected static String className(Class<?> clazz) {
        String className;
        switch (className = clazz.getSimpleName().toLowerCase().replace("$", " ")) {
            case "redenvelope": {
                return "red_envelope";
            }
            case "batchrefund": {
                return "batch_refund";
            }
            case "batchtransfer": {
                return "batch_transfer";
            }
            case "customs": {
                return "custom";
            }
            case "cardinfo": {
                return "card_info";
            }
            case "assettransaction": {
                return "asset_transaction";
            }
            case "balancebonus": {
                return "balance_bonuse";
            }
            case "balancetransfer": {
                return "balance_transfer";
            }
            case "balancetransaction": {
                return "balance_transaction";
            }
            case "coupontemplate": {
                return "coupon_template";
            }
            case "batchwithdrawal": {
                return "batch_withdrawal";
            }
            case "transactionstatistics": {
                return "transaction_statistics";
            }
            case "settleaccount": {
                return "settle_account";
            }
            case "subapp": {
                return "sub_app";
            }
            case "royalty": {
                return "royaltie";
            }
            case "royaltysettlement": {
                return "royalty_settlement";
            }
            case "royaltytransaction": {
                return "royalty_transaction";
            }
            case "royaltytemplate": {
                return "royalty_template";
            }
            case "balancesettlement": {
                return "balance_settlement";
            }
            case "subbank": {
                return "sub_bank";
            }
            case "splitreceiver": {
                return "split_receiver";
            }
            case "splitprofit": {
                return "split_profit";
            }
            case "profittransaction": {
                return "profit_transaction";
            }
            case "userpic": {
                return "users/upload_pic";
            }
            case "contact": {
                return "sub_apps/contact";
            }
        }
        return className;
    }

    protected static String singleClassURL(Class<?> clazz) {
        String className = null;
        Class<?> klass = APIResource.getSelfClass();
        if (!klass.getSimpleName().equalsIgnoreCase("APIResource")) {
            try {
                Method method = klass.getMethod("className", Class.class);
                className = (String)method.invoke(klass, clazz);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (className == null) {
            className = APIResource.className(clazz);
        }
        return String.format("%s/v1/%s", Pingpp.getApiBase(), className);
    }

    protected static String classURL(Class<?> clazz) {
        return String.format("%ss", APIResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) {
        return String.format("%s/%s", APIResource.classURL(clazz), APIResource.urlEncode(id));
    }

    protected static String apiBasePrefixedURL(String url) {
        return String.format("%s%s", Pingpp.getApiBase(), url);
    }

    protected static String urlEncode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return URLEncoder.encode(str, CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is unknown");
        }
    }

    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz, RequestOptions options) throws PingppException {
        PingppRequest request = new PingppRequest(method, url, params, options);
        PingppResponse response = httpClient.requestWithRetries(request);
        int responseCode = response.getResponseCode();
        String responseBody = response.getResponseBody();
        if (responseCode < 200 || responseCode >= 300) {
            APIResource.handleAPIError(response);
        }
        Object resource = null;
        try {
            resource = APIResource.getGson().fromJson(responseBody, clazz);
        }
        catch (JsonSyntaxException e) {
            APIResource.raiseMalformedJsonError(responseBody, responseCode);
        }
        if (resource instanceof PingppObject) {
            PingppObject obj = (PingppObject)resource;
            obj.setLastResponse(response);
        }
        return (T)resource;
    }

    private static void handleAPIError(PingppResponse response) throws PingppException {
        PingppError error = null;
        String rBody = response.getResponseBody();
        int rCode = response.getResponseCode();
        try {
            JsonObject jsonObject = ((JsonObject)GSON.fromJson(rBody, JsonObject.class)).getAsJsonObject("error");
            error = (PingppError)GSON.fromJson((JsonElement)jsonObject, PingppError.class);
        }
        catch (JsonSyntaxException e) {
            APIResource.raiseMalformedJsonError(rBody, rCode);
        }
        switch (rCode) {
            case 400: 
            case 404: {
                throw new InvalidRequestException(error.getMessage(), error.getType(), error.getCode(), error.getParam(), rCode, null);
            }
            case 403: 
            case 429: {
                throw new RateLimitException(error.getMessage(), error.getType(), error.getCode(), rCode, null);
            }
            case 402: {
                throw new ChannelException(error.getMessage(), error.getType(), error.getCode(), error.getParam(), rCode, null);
            }
            case 401: {
                throw new AuthenticationException(error.getMessage(), error.getType(), error.getCode(), rCode, null);
            }
            case 502: {
                throw new APIConnectionException(error.getMessage());
            }
        }
        throw new APIException(error.getMessage(), error.getType(), error.getCode(), rCode, null);
    }

    private static void raiseMalformedJsonError(String responseBody, int responseCode) throws APIException {
        throw new APIException(String.format("Invalid response object from API: %s. (HTTP response code was %d)", responseBody, responseCode), null, null, responseCode, null);
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

