/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.model;

import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.exception.RateLimitException;
import com.pingplusplus.model.BalanceTransaction;
import com.pingplusplus.model.SettleAccount;
import com.pingplusplus.model.UserCollection;
import com.pingplusplus.net.APIResource;
import com.pingplusplus.net.AppBasedResource;
import java.util.List;
import java.util.Map;

public class User
extends AppBasedResource {
    String id;
    String object;
    String app;
    String address;
    Integer availableBalance;
    Integer availableCoupons;
    String avatar;
    Long created;
    Boolean disabled;
    String email;
    String gender;
    Boolean identified;
    Boolean livemode;
    String mobile;
    String name;
    Map<String, Object> metadata;
    String relatedApp;
    List<SettleAccount> settleAccounts;
    String type;
    Integer withdrawableBalance;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getAvailableCoupons() {
        return this.availableCoupons;
    }

    public void setAvailableCoupons(Integer availableCoupons) {
        this.availableCoupons = availableCoupons;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public Integer getAvailableBalance() {
        return this.availableBalance;
    }

    public void setAvailableBalance(Integer availableBalance) {
        this.availableBalance = availableBalance;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public Boolean getIdentified() {
        return this.identified;
    }

    public void setIdentified(Boolean identified) {
        this.identified = identified;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public Integer getWithdrawableBalance() {
        return this.withdrawableBalance;
    }

    public void setWithdrawableBalance(Integer withdrawableBalance) {
        this.withdrawableBalance = withdrawableBalance;
    }

    public String getRelatedApp() {
        return this.relatedApp;
    }

    public void setRelatedApp(String relatedApp) {
        this.relatedApp = relatedApp;
    }

    public List<SettleAccount> getSettleAccounts() {
        return this.settleAccounts;
    }

    public void setSettleAccounts(List<SettleAccount> settleAccounts) {
        this.settleAccounts = settleAccounts;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static User create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return User.request(APIResource.RequestMethod.POST, User.classURL(User.class), params, User.class);
    }

    public static User retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        User.checkUserId(id);
        return User.request(APIResource.RequestMethod.GET, User.instanceURL(User.class, id), null, User.class);
    }

    public static UserCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return User.request(APIResource.RequestMethod.GET, User.classURL(User.class), params, UserCollection.class);
    }

    public static User update(String id, Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        User.checkUserId(id);
        return User.request(APIResource.RequestMethod.PUT, User.instanceURL(User.class, id), params, User.class);
    }

    @Deprecated
    public static BalanceTransaction createBalanceTranfer(String userId, Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        User.checkUserId(userId);
        return User.request(APIResource.RequestMethod.POST, String.format("%s/transfers", User.instanceURL(User.class, userId)), params, BalanceTransaction.class);
    }

    public static void checkUserId(String userId) throws InvalidRequestException {
        if (userId == null || userId.trim().length() == 0) {
            throw new InvalidRequestException("ID should not be null or empty.", "user_id", null);
        }
    }
}

