/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.model;

import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.exception.RateLimitException;
import com.pingplusplus.model.BalanceTransaction;
import com.pingplusplus.model.SettleAccount;
import com.pingplusplus.model.UserCollection;
import com.pingplusplus.net.APIResource;
import com.pingplusplus.net.AppBasedResource;
import java.util.List;
import java.util.Map;

public class User
extends AppBasedResource {
    String id;
    String object;
    String app;
    String address;
    Integer availableBalance;
    Integer availableCoupons;
    String avatar;
    Long created;
    Boolean disabled;
    String email;
    String gender;
    Boolean identified;
    Boolean livemode;
    String mobile;
    String name;
    Map<String, Object> metadata;
    String relatedApp;
    List<SettleAccount> settleAccounts;
    String type;
    Integer withdrawableBalance;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String string) {
        this.object = string;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String string) {
        this.app = string;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public Integer getAvailableCoupons() {
        return this.availableCoupons;
    }

    public void setAvailableCoupons(Integer n) {
        this.availableCoupons = n;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String string) {
        this.avatar = string;
    }

    public Integer getAvailableBalance() {
        return this.availableBalance;
    }

    public void setAvailableBalance(Integer n) {
        this.availableBalance = n;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long l) {
        this.created = l;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean bl) {
        this.disabled = bl;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String string) {
        this.gender = string;
    }

    public Boolean getIdentified() {
        return this.identified;
    }

    public void setIdentified(Boolean bl) {
        this.identified = bl;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean bl) {
        this.livemode = bl;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String string) {
        this.mobile = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> map) {
        this.metadata = map;
    }

    public Integer getWithdrawableBalance() {
        return this.withdrawableBalance;
    }

    public void setWithdrawableBalance(Integer n) {
        this.withdrawableBalance = n;
    }

    public String getRelatedApp() {
        return this.relatedApp;
    }

    public void setRelatedApp(String string) {
        this.relatedApp = string;
    }

    public List<SettleAccount> getSettleAccounts() {
        return this.settleAccounts;
    }

    public void setSettleAccounts(List<SettleAccount> list) {
        this.settleAccounts = list;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public static User create(Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return User.request(APIResource.RequestMethod.POST, User.classURL(User.class), map, User.class);
    }

    public static User retrieve(String string) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        User.checkUserId(string);
        return User.request(APIResource.RequestMethod.GET, User.instanceURL(User.class, string), null, User.class);
    }

    public static UserCollection list(Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        return User.request(APIResource.RequestMethod.GET, User.classURL(User.class), map, UserCollection.class);
    }

    public static User update(String string, Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        User.checkUserId(string);
        return User.request(APIResource.RequestMethod.PUT, User.instanceURL(User.class, string), map, User.class);
    }

    @Deprecated
    public static BalanceTransaction createBalanceTranfer(String string, Map<String, Object> map) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException, RateLimitException {
        User.checkUserId(string);
        return User.request(APIResource.RequestMethod.POST, String.format("%s/transfers", User.instanceURL(User.class, string)), map, BalanceTransaction.class);
    }

    public static void checkUserId(String string) throws InvalidRequestException {
        if (string == null || string.trim().length() == 0) {
            throw new InvalidRequestException("ID should not be null or empty.", "user_id", null);
        }
    }
}

