/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.EventData;
import com.pingplusplus.model.PingppObject;
import com.pingplusplus.model.PingppRawJsonObject;
import com.pingplusplus.model.RedEnvelope;
import com.pingplusplus.model.Refund;
import com.pingplusplus.model.Summary;
import com.pingplusplus.model.Transfer;
import com.pingplusplus.net.APIResource;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventDataDeserializer
implements JsonDeserializer<EventData> {
    static final Map<String, Class> objectMap = new HashMap<String, Class>();

    private Object deserializeJsonPrimitive(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        if (jsonPrimitive.isNumber()) {
            return jsonPrimitive.getAsNumber();
        }
        return jsonPrimitive.getAsString();
    }

    private Object[] deserializeJsonArray(JsonArray jsonArray) {
        Object[] objectArray = new Object[jsonArray.size()];
        Iterator iterator = jsonArray.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            JsonElement jsonElement = (JsonElement)iterator.next();
            objectArray[n++] = this.deserializeJsonElement(jsonElement);
        }
        return objectArray;
    }

    private Object deserializeJsonElement(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonObject()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.populateMapFromJSONObject(hashMap, jsonElement.getAsJsonObject());
            return hashMap;
        }
        if (jsonElement.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(jsonElement.getAsJsonPrimitive());
        }
        if (jsonElement.isJsonArray()) {
            return this.deserializeJsonArray(jsonElement.getAsJsonArray());
        }
        System.err.println("Unknown JSON element type for element " + jsonElement + ".");
        return null;
    }

    private void populateMapFromJSONObject(Map<String, Object> map, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String string = (String)entry.getKey();
            JsonElement jsonElement = (JsonElement)entry.getValue();
            map.put(string, this.deserializeJsonElement(jsonElement));
        }
    }

    public EventData deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        EventData eventData = new EventData();
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String string = (String)entry.getKey();
                JsonElement jsonElement2 = (JsonElement)entry.getValue();
                if (!"object".equals(string)) continue;
                String string2 = jsonElement2.getAsJsonObject().get("object").getAsString();
                Class<PingppRawJsonObject> clazz = objectMap.get(string2);
                PingppObject pingppObject = (PingppObject)APIResource.GSON.fromJson((JsonElement)entry.getValue(), clazz != null ? clazz : PingppRawJsonObject.class);
                eventData.setObject(pingppObject);
            }
        }
        return eventData;
    }

    static {
        objectMap.put("charge", Charge.class);
        objectMap.put("transfer", Transfer.class);
        objectMap.put("refund", Refund.class);
        objectMap.put("red_envelope", RedEnvelope.class);
        objectMap.put("account_daily_summary", Summary.class);
        objectMap.put("account_weekly_summary", Summary.class);
        objectMap.put("account_monthly_summary", Summary.class);
        objectMap.put("app_monthly_summary", Summary.class);
        objectMap.put("app_daily_summary", Summary.class);
        objectMap.put("app_weekly_summary", Summary.class);
    }
}

