/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeRefundCollection;
import com.pingplusplus.model.EventData;
import com.pingplusplus.model.PingppObject;
import com.pingplusplus.model.PingppRawJsonObject;
import com.pingplusplus.model.RedEnvelope;
import com.pingplusplus.model.Transfer;
import com.pingplusplus.net.ChargeDeserializer;
import com.pingplusplus.net.ChargeRefundCollectionDeserializer;
import com.pingplusplus.net.EventDataDeserializer;
import com.pingplusplus.net.PingppRawJsonObjectDeserializer;
import com.pingplusplus.net.PingppResponse;
import com.pingplusplus.net.RedEnvelopeDeserializer;
import com.pingplusplus.net.TransferDeserializer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.codec.binary.Base64;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

public abstract class APIResource
extends PingppObject {
    public static final String CHARSET = "UTF-8";
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Charge.class, (Object)new ChargeDeserializer()).registerTypeAdapter(RedEnvelope.class, (Object)new RedEnvelopeDeserializer()).registerTypeAdapter(Transfer.class, (Object)new TransferDeserializer()).registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).registerTypeAdapter(EventData.class, (Object)new EventDataDeserializer()).registerTypeAdapter(PingppRawJsonObject.class, (Object)new PingppRawJsonObjectDeserializer()).create();

    private static String className(Class<?> clazz) {
        String string = clazz.getSimpleName().toLowerCase().replace("$", " ");
        if (string.equals("redenvelope")) {
            return "red_envelope";
        }
        if (string.equals("smscode")) {
            return "sms_code";
        }
        return string;
    }

    protected static String singleClassURL(Class<?> clazz) {
        return String.format("%s/v1/%s", Pingpp.getApiBase(), APIResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) {
        return String.format("%ss", APIResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String string) throws InvalidRequestException {
        try {
            return String.format("%s/%s", APIResource.classURL(clazz), APIResource.urlEncode(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8", null, unsupportedEncodingException);
        }
    }

    private static String urlEncode(String string) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string, CHARSET);
    }

    private static String urlEncodePair(String string, String string2) throws UnsupportedEncodingException {
        return String.format("%s=%s", APIResource.urlEncode(string), APIResource.urlEncode(string2));
    }

    static Map<String, String> getHeaders(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Accept-Charset", CHARSET);
        hashMap.put("User-Agent", String.format("Pingpp/v1 JavaBindings/%s", "2.1.5"));
        if (string == null) {
            string = Pingpp.apiKey;
        }
        hashMap.put("Authorization", String.format("Bearer %s", string));
        hashMap.put("Accept-Language", Pingpp.AcceptLanguage);
        String[] stringArray = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String string2 : stringArray) {
            hashMap2.put(string2, System.getProperty(string2));
        }
        hashMap2.put("bindings.version", "2.1.5");
        hashMap2.put("lang", "Java");
        hashMap2.put("publisher", "Pingpp");
        hashMap.put("X-Pingpp-Client-User-Agent", GSON.toJson(hashMap2));
        if (Pingpp.apiVersion != null) {
            hashMap.put("Pingplusplus-Version", Pingpp.apiVersion);
        }
        return hashMap;
    }

    private static HttpURLConnection createPingppConnection(String string, String string2) throws IOException {
        URL uRL = null;
        uRL = new URL(string);
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setConnectTimeout(30000);
        httpsURLConnection.setReadTimeout(80000);
        httpsURLConnection.setUseCaches(false);
        for (Map.Entry<String, String> entry : APIResource.getHeaders(string2).entrySet()) {
            httpsURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        return httpsURLConnection;
    }

    private static void throwInvalidCertificateException() throws APIConnectionException {
        throw new APIConnectionException("Invalid server certificate. You tried to connect to a server that has a revoked SSL certificate, which means we cannot securely send data to that server. ");
    }

    private static String formatURL(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            return string;
        }
        String string3 = string.contains("?") ? "&" : "?";
        return String.format("%s%s%s", string, string3, string2);
    }

    private static HttpURLConnection createGetConnection(String string, String string2, String string3) throws IOException, APIConnectionException {
        String string4 = APIResource.formatURL(string, string2);
        HttpURLConnection httpURLConnection = APIResource.createPingppConnection(string4, string3);
        httpURLConnection.setRequestMethod("GET");
        return httpURLConnection;
    }

    private static HttpURLConnection createDeleteConnection(String string, String string2, String string3) throws IOException, APIConnectionException {
        String string4 = APIResource.formatURL(string, string2);
        HttpURLConnection httpURLConnection = APIResource.createPingppConnection(string4, string3);
        httpURLConnection.setRequestMethod("DELETE");
        return httpURLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPostConnection(String string, String string2, String string3) throws IOException, APIConnectionException {
        HttpURLConnection httpURLConnection = APIResource.createPingppConnection(string, string3);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", String.format("application/json;charset=%s", CHARSET));
        String string4 = APIResource.generateSign(string2);
        if (string4 != null) {
            httpURLConnection.setRequestProperty("Pingplusplus-Signature", string4);
        }
        OutputStream outputStream = null;
        try {
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(string2.getBytes(CHARSET));
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return httpURLConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPutConnection(String string, String string2, String string3) throws IOException, APIConnectionException {
        HttpURLConnection httpURLConnection = APIResource.createPingppConnection(string, string3);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setRequestMethod("PUT");
        httpURLConnection.setRequestProperty("Content-Type", String.format("application/json;charset=%s", CHARSET));
        String string4 = APIResource.generateSign(string2);
        if (string4 != null) {
            httpURLConnection.setRequestProperty("Pingplusplus-Signature", string4);
        }
        OutputStream outputStream = null;
        try {
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(string2.getBytes(CHARSET));
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return httpURLConnection;
    }

    private static String createQuery(Map<String, Object> map) throws UnsupportedEncodingException, InvalidRequestException {
        Map<String, String> map2 = APIResource.flattenParams(map);
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(APIResource.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return stringBuilder.toString();
    }

    private static String createJSONString(Map<String, Object> map) {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
        return gson.toJson(map);
    }

    private static Map<String, String> flattenParams(Map<String, Object> map) throws InvalidRequestException {
        if (map == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            HashMap<String, Object> hashMap2;
            Cloneable cloneable;
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof Map) {
                cloneable = new HashMap();
                hashMap2 = (HashMap<String, Object>)object;
                for (Map.Entry entry2 : hashMap2.entrySet()) {
                    cloneable.put(String.format("%s[%s]", string, entry2.getKey()), entry2.getValue());
                }
                hashMap.putAll(APIResource.flattenParams((Map<String, Object>)((Object)cloneable)));
                continue;
            }
            if (object instanceof ArrayList) {
                cloneable = (ArrayList)object;
                hashMap2 = new HashMap<String, Object>();
                int n = ((ArrayList)cloneable).size();
                for (int i = 0; i < n; ++i) {
                    hashMap2.put(String.format("%s[%d]", string, i), ((ArrayList)cloneable).get(i));
                }
                hashMap.putAll(APIResource.flattenParams(hashMap2));
                continue;
            }
            if ("".equals(object)) {
                throw new InvalidRequestException("You cannot set '" + string + "' to an empty string. " + "We interpret empty strings as null in requests. " + "You may set '" + string + "' to null to delete the property.", string, null);
            }
            if (object == null) {
                hashMap.put(string, "");
                continue;
            }
            hashMap.put(string, object.toString());
        }
        return hashMap;
    }

    private static String getResponseBody(InputStream inputStream) throws IOException {
        String string = new Scanner(inputStream, CHARSET).useDelimiter("\\A").next();
        inputStream.close();
        return string;
    }

    private static PingppResponse makeURLConnectionRequest(RequestMethod requestMethod, String string, String string2, String string3) throws APIConnectionException {
        HttpURLConnection httpURLConnection = null;
        try {
            switch (requestMethod) {
                case GET: {
                    httpURLConnection = APIResource.createGetConnection(string, string2, string3);
                    break;
                }
                case POST: {
                    httpURLConnection = APIResource.createPostConnection(string, string2, string3);
                    break;
                }
                case DELETE: {
                    httpURLConnection = APIResource.createDeleteConnection(string, string2, string3);
                    break;
                }
                case PUT: {
                    httpURLConnection = APIResource.createPutConnection(string, string2, string3);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. ", new Object[]{requestMethod}));
                }
            }
            int n = httpURLConnection.getResponseCode();
            String string4 = null;
            string4 = n >= 200 && n < 300 ? APIResource.getResponseBody(httpURLConnection.getInputStream()) : APIResource.getResponseBody(httpURLConnection.getErrorStream());
            Map<String, List<String>> map = httpURLConnection.getHeaderFields();
            PingppResponse pingppResponse = new PingppResponse(n, string4, map);
            return pingppResponse;
        }
        catch (IOException iOException) {
            throw new APIConnectionException(String.format("IOException during API request to Pingpp (%s): %s Please check your internet connection and try again. If this problem persists,you should check Pingpp's service status at https://pingxx.com, or let us know at support@pingxx.com.", Pingpp.getApiBase(), iOException.getMessage()), iOException);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    protected static <T> T request(RequestMethod requestMethod, String string, Map<String, Object> map, Class<T> clazz) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException {
        if (Pingpp.apiKey == null || Pingpp.apiKey.length() == 0) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Pingpp.apiKey = <API-KEY>'. You can generate API keys from the Pingpp web interface. See https://pingxx.com for details.");
        }
        String string2 = null;
        switch (requestMethod) {
            case GET: 
            case DELETE: {
                try {
                    string2 = APIResource.createQuery(map);
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InvalidRequestException("Unable to encode parameters to UTF-8", null, unsupportedEncodingException);
                }
            }
            case POST: 
            case PUT: {
                string2 = APIResource.createJSONString(map);
            }
        }
        PingppResponse pingppResponse = APIResource.makeURLConnectionRequest(requestMethod, string, string2, Pingpp.apiKey);
        int n = pingppResponse.getResponseCode();
        String string3 = pingppResponse.getResponseBody();
        if (n < 200 || n >= 300) {
            APIResource.handleAPIError(string3, n);
        }
        return (T)GSON.fromJson(string3, clazz);
    }

    private static void handleAPIError(String string, int n) throws InvalidRequestException, AuthenticationException, APIException, ChannelException {
        Error error = ((ErrorContainer)GSON.fromJson(string, ErrorContainer.class)).error;
        switch (n) {
            case 400: {
                throw new InvalidRequestException(error.toString(), error.param, null);
            }
            case 404: {
                throw new InvalidRequestException(error.toString(), error.param, null);
            }
            case 402: {
                throw new ChannelException(error.toString(), error.param, null);
            }
            case 401: {
                throw new AuthenticationException(error.toString());
            }
        }
        throw new APIException(error.toString(), null);
    }

    private static String generateSign(String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (Pingpp.privateKey == null) {
            if (Pingpp.privateKeyPath == null) {
                return null;
            }
            object3 = new FileInputStream(Pingpp.privateKeyPath);
            object2 = new byte[((FileInputStream)object3).available()];
            ((FileInputStream)object3).read((byte[])object2);
            ((FileInputStream)object3).close();
            object = new String((byte[])object2, CHARSET);
            Pingpp.privateKey = ((String)object).replaceAll("(-+BEGIN (RSA )?PRIVATE KEY-+\\r?\\n|-+END (RSA )?PRIVATE KEY-+\\r?\\n?)", "");
        }
        if (((DerValue[])(object = ((DerInputStream)(object2 = new DerInputStream((byte[])(object3 = Base64.decodeBase64((String)Pingpp.privateKey))))).getSequence(0))).length < 9) {
            System.out.println("Could not parse a PKCS1 private key.");
            return null;
        }
        BigInteger bigInteger = object[1].getBigInteger();
        BigInteger bigInteger2 = object[2].getBigInteger();
        BigInteger bigInteger3 = ((DerValue)object[3]).getBigInteger();
        BigInteger bigInteger4 = ((DerValue)object[4]).getBigInteger();
        BigInteger bigInteger5 = ((DerValue)object[5]).getBigInteger();
        BigInteger bigInteger6 = ((DerValue)object[6]).getBigInteger();
        BigInteger bigInteger7 = ((DerValue)object[7]).getBigInteger();
        BigInteger bigInteger8 = ((DerValue)object[8]).getBigInteger();
        RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(string.getBytes());
            byte[] byArray = signature.sign();
            return Base64.encodeBase64String((byte[])byArray).replaceAll("\n|\r", "");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (SignatureException signatureException) {
            signatureException.printStackTrace();
        }
        return null;
    }

    private static class Error {
        String type;
        String message;
        String code;
        String param;

        private Error() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (null != this.type && !this.type.isEmpty()) {
                stringBuffer.append("Error type: " + this.type + "\n");
            }
            if (null != this.message && !this.message.isEmpty()) {
                stringBuffer.append("\t Error message: " + this.message + "\n");
            }
            if (null != this.code && !this.code.isEmpty()) {
                stringBuffer.append("\t Error code: " + this.code + "\n");
            }
            return stringBuffer.toString();
        }
    }

    private static class ErrorContainer {
        private Error error;

        private ErrorContainer() {
        }
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

