/*
 * Decompiled with CFR 0.152.
 */
package com.pingplusplus.net;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pingplusplus.Pingpp;
import com.pingplusplus.exception.APIConnectionException;
import com.pingplusplus.exception.APIException;
import com.pingplusplus.exception.AuthenticationException;
import com.pingplusplus.exception.ChannelException;
import com.pingplusplus.exception.InvalidRequestException;
import com.pingplusplus.model.Charge;
import com.pingplusplus.model.ChargeRefundCollection;
import com.pingplusplus.model.PingppObject;
import com.pingplusplus.model.RedEnvelope;
import com.pingplusplus.model.Transfer;
import com.pingplusplus.net.ChargeDeserializer;
import com.pingplusplus.net.ChargeRefundCollectionDeserializer;
import com.pingplusplus.net.PingppResponse;
import com.pingplusplus.net.RedEnvelopeDeserializer;
import com.pingplusplus.net.TransferDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;

public abstract class APIResource
extends PingppObject {
    public static final String CHARSET = "UTF-8";
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(Charge.class, (Object)new ChargeDeserializer()).registerTypeAdapter(RedEnvelope.class, (Object)new RedEnvelopeDeserializer()).registerTypeAdapter(Transfer.class, (Object)new TransferDeserializer()).registerTypeAdapter(ChargeRefundCollection.class, (Object)new ChargeRefundCollectionDeserializer()).create();

    private static String className(Class<?> clazz) {
        String className = clazz.getSimpleName().toLowerCase().replace("$", " ");
        if (className.equals("redenvelope")) {
            return "red_envelope";
        }
        return className;
    }

    protected static String singleClassURL(Class<?> clazz) {
        return String.format("%s/v1/%s", Pingpp.getApiBase(), APIResource.className(clazz));
    }

    protected static String classURL(Class<?> clazz) {
        return String.format("%ss", APIResource.singleClassURL(clazz));
    }

    protected static String instanceURL(Class<?> clazz, String id) throws InvalidRequestException {
        try {
            return String.format("%s/%s", APIResource.classURL(clazz), APIResource.urlEncode(id));
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8", null, e);
        }
    }

    private static String urlEncode(String str) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        return URLEncoder.encode(str, CHARSET);
    }

    private static String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        return String.format("%s=%s", APIResource.urlEncode(k), APIResource.urlEncode(v));
    }

    static Map<String, String> getHeaders(String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept-Charset", CHARSET);
        headers.put("User-Agent", String.format("Pingpp/v1 JavaBindings/%s", "2.0.9"));
        if (apiKey == null) {
            apiKey = Pingpp.apiKey;
        }
        headers.put("Authorization", String.format("Bearer %s", apiKey));
        headers.put("Accept-Language", Pingpp.AcceptLanguage);
        String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String propertyName : propertyNames) {
            propertyMap.put(propertyName, System.getProperty(propertyName));
        }
        propertyMap.put("bindings.version", "2.0.9");
        propertyMap.put("lang", "Java");
        propertyMap.put("publisher", "Pingpp");
        headers.put("X-Pingpp-Client-User-Agent", GSON.toJson(propertyMap));
        if (Pingpp.apiVersion != null) {
            headers.put("Pingplusplus-Version", Pingpp.apiVersion);
        }
        return headers;
    }

    private static HttpURLConnection createPingppConnection(String url, String apiKey) throws IOException {
        URL pingppURL = null;
        pingppURL = new URL(url);
        HttpsURLConnection conn = (HttpsURLConnection)pingppURL.openConnection();
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : APIResource.getHeaders(apiKey).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    private static void throwInvalidCertificateException() throws APIConnectionException {
        throw new APIConnectionException("Invalid server certificate. You tried to connect to a server that has a revoked SSL certificate, which means we cannot securely send data to that server. ");
    }

    private static void checkSSLCert(HttpURLConnection hconn) throws IOException, APIConnectionException {
        if (!Pingpp.getVerifySSL() && !hconn.getURL().getHost().equals("api.pingxx.com")) {
            return;
        }
    }

    private static String formatURL(String url, String query) {
        if (query == null || query.isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    private static HttpURLConnection createGetConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        String getURL = APIResource.formatURL(url, query);
        HttpURLConnection conn = APIResource.createPingppConnection(getURL, apiKey);
        conn.setRequestMethod("GET");
        APIResource.checkSSLCert(conn);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection createPostConnection(String url, String query, String apiKey) throws IOException, APIConnectionException {
        HttpURLConnection conn = APIResource.createPingppConnection(url, apiKey);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", String.format("application/x-www-form-urlencoded;charset=%s", CHARSET));
        APIResource.checkSSLCert(conn);
        OutputStream output = null;
        try {
            output = conn.getOutputStream();
            output.write(query.getBytes(CHARSET));
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
        return conn;
    }

    private static String createQuery(Map<String, Object> params) throws UnsupportedEncodingException, InvalidRequestException {
        Map<String, String> flatParams = APIResource.flattenParams(params);
        StringBuilder queryStringBuffer = new StringBuilder();
        for (Map.Entry<String, String> entry : flatParams.entrySet()) {
            if (queryStringBuffer.length() > 0) {
                queryStringBuffer.append("&");
            }
            queryStringBuffer.append(APIResource.urlEncodePair(entry.getKey(), entry.getValue()));
        }
        return queryStringBuffer.toString();
    }

    private static Map<String, String> flattenParams(Map<String, Object> params) throws InvalidRequestException {
        if (params == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> flatParams = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                Map nestedMap = (Map)value;
                for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                    flatNestedMap.put(String.format("%s[%s]", key, nestedEntry.getKey()), nestedEntry.getValue());
                }
                flatParams.putAll(APIResource.flattenParams(flatNestedMap));
                continue;
            }
            if (value instanceof ArrayList) {
                ArrayList ar = (ArrayList)value;
                HashMap<String, Object> flatNestedMap = new HashMap<String, Object>();
                int size = ar.size();
                for (int i = 0; i < size; ++i) {
                    flatNestedMap.put(String.format("%s[%d]", key, i), ar.get(i));
                }
                flatParams.putAll(APIResource.flattenParams(flatNestedMap));
                continue;
            }
            if ("".equals(value)) {
                throw new InvalidRequestException("You cannot set '" + key + "' to an empty string. " + "We interpret empty strings as null in requests. " + "You may set '" + key + "' to null to delete the property.", key, null);
            }
            if (value == null) {
                flatParams.put(key, "");
                continue;
            }
            flatParams.put(key, value.toString());
        }
        return flatParams;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        String rBody = new Scanner(responseStream, CHARSET).useDelimiter("\\A").next();
        responseStream.close();
        return rBody;
    }

    private static PingppResponse makeURLConnectionRequest(RequestMethod method, String url, String query, String apiKey) throws APIConnectionException {
        HttpURLConnection conn = null;
        try {
            switch (method) {
                case GET: {
                    conn = APIResource.createGetConnection(url, query, apiKey);
                    break;
                }
                case POST: {
                    conn = APIResource.createPostConnection(url, query, apiKey);
                    break;
                }
                default: {
                    throw new APIConnectionException(String.format("Unrecognized HTTP method %s. ", new Object[]{method}));
                }
            }
            int rCode = conn.getResponseCode();
            String rBody = null;
            rBody = rCode >= 200 && rCode < 300 ? APIResource.getResponseBody(conn.getInputStream()) : APIResource.getResponseBody(conn.getErrorStream());
            Map<String, List<String>> headers = conn.getHeaderFields();
            PingppResponse pingppResponse = new PingppResponse(rCode, rBody, headers);
            return pingppResponse;
        }
        catch (IOException e) {
            throw new APIConnectionException(String.format("IOException during API request to Pingpp (%s): %s Please check your internet connection and try again. If this problem persists,you should check Pingpp's service status at https://pingxx.com, or let us know at support@pingxx.com.", Pingpp.getApiBase(), e.getMessage()), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    protected static <T> T request(RequestMethod method, String url, Map<String, Object> params, Class<T> clazz) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, ChannelException {
        String query;
        if (Pingpp.apiKey == null || Pingpp.apiKey.length() == 0) {
            throw new AuthenticationException("No API key provided. (HINT: set your API key using 'Pingpp.apiKey = <API-KEY>'. You can generate API keys from the Pingpp web interface. See https://pingxx.com for details.");
        }
        try {
            query = APIResource.createQuery(params);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidRequestException("Unable to encode parameters to UTF-8", null, e);
        }
        PingppResponse response = APIResource.makeURLConnectionRequest(method, url, query, Pingpp.apiKey);
        int rCode = response.getResponseCode();
        String rBody = response.getResponseBody();
        if (rCode < 200 || rCode >= 300) {
            APIResource.handleAPIError(rBody, rCode);
        }
        return (T)GSON.fromJson(rBody, clazz);
    }

    private static void handleAPIError(String rBody, int rCode) throws InvalidRequestException, AuthenticationException, APIException, ChannelException {
        Error error = ((ErrorContainer)GSON.fromJson(rBody, ErrorContainer.class)).error;
        switch (rCode) {
            case 400: {
                throw new InvalidRequestException(error.toString(), error.param, null);
            }
            case 404: {
                throw new InvalidRequestException(error.toString(), error.param, null);
            }
            case 402: {
                throw new ChannelException(error.toString(), error.param, null);
            }
            case 401: {
                throw new AuthenticationException(error.toString());
            }
        }
        throw new APIException(error.toString(), null);
    }

    private static class Error {
        String type;
        String message;
        String code;
        String param;

        private Error() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (null != this.type && !this.type.isEmpty()) {
                sb.append("Error type: " + this.type + "\n");
            }
            if (null != this.message && !this.message.isEmpty()) {
                sb.append("\t Error message: " + this.message + "\n");
            }
            if (null != this.code && !this.code.isEmpty()) {
                sb.append("\t Error code: " + this.code + "\n");
            }
            return sb.toString();
        }
    }

    private static class ErrorContainer {
        private Error error;

        private ErrorContainer() {
        }
    }

    protected static enum RequestMethod {
        GET,
        POST;

    }
}

